<?php

namespace Hub4all;

use Domain\Hub4all\API\Service\Hub4allHttpClient;
use Domain\Order\Service\OrderService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class OrderTest extends TestCase
{
    use RefreshDatabase;

    public function test_get_orders_from_hub4all(){
        $hub4allClient = new Hub4allHttpClient();

        $filter = [
            'status' => 2,
            'startDate' => '2024-12-01',
            'endDate' => '2024-12-31',
        ];

        $response = $hub4allClient->ordersGetAll($filter);

        if(count($response['data']['list']) > 0){
            $orderModel = new OrderService();
            foreach($response['data']['list'] as $orderItem){
                $orderModel->importFromHub4all($orderItem);
            }
        }
    }
}
