<?php

namespace Domain\Protheus\API\Services;


use Domain\Customer\Models\CustomerModel;

class ProtheusService
{

    private ProtheusHttpClient $protheusHttpClient;

    public function __construct()
    {
        $this->protheusHttpClient = new ProtheusHttpClient();
    }

    public function createOrder(array $hubOrderItem)
    {
        self::createClient($hubOrderItem['customer'], $hubOrderItem['transaction']['billingAddress']);

        $protheusOrder = self::mountOrderArray($hubOrderItem);

//        $itemTest = $protheusOrder['itens'][0];
//        $protheusOrder['itens'] = [];
//        $protheusOrder['itens'][] = $itemTest;

        return $this->protheusHttpClient->orderCreate($protheusOrder);
    }

    private function mountOrderArray(array $orderItem): array
    {
        $products = [];
        foreach($orderItem['items'] as $item){
            $products[] = [
                "produto" => $item['sku'],
//                "produto" => "061166",
                "quantidade" => $item['quantity'],
                "unitario" => $item['originalPrice'],
                "total" => $item['specialPrice'],
                "desconto" => $item['originalPrice'] - $item['specialPrice'],
            ];
        }

        $dateCreated = new \DateTime($orderItem['date']['date']);
        $dateApproved = new \DateTime($orderItem['approvedAt']['date']);

        return [
            "pedido" => str_pad($orderItem['alternativeId'], 6, '0', STR_PAD_LEFT),
            "total" => $orderItem['total'],
            "promotionDiscount" => "",
            "dataCriacao" => date_format($dateCreated, 'Y-m-d H:i:s'),
            "dataUpdate" => "",
            "deleteAt" => "",
            "condicaopgto" => "780",
            "mensagem" => "",
            "status" => [
                "name" => "status.paid",
                "info" => "",
                "createdAt" => date_format($dateApproved, 'Y-m-d H:i:s'),
                "updatedBy" => [],
            ],
            "cliente" => [
                "numdoc" => preg_replace('/\D/', '', $orderItem['customer']['cpfCnpj']),
                "nome" => $orderItem['customer']['fullName'],
                "cep" => preg_replace('/\D/', '', $orderItem['transaction']['billingAddress']['zipCode']),
                "endereco" => $orderItem['transaction']['billingAddress']['street'],
                "numero" => $orderItem['transaction']['billingAddress']['number'],
                "complemento" => $orderItem['transaction']['billingAddress']['complement'],
                "bairro" => $orderItem['transaction']['billingAddress']['neighborhood'],
                "cidade" => $orderItem['transaction']['billingAddress']['city'],
                "estado" => $orderItem['transaction']['billingAddress']['state']['name'],
            ],
            "entrega" => [
                "cepent" => preg_replace('/\D/', '', $orderItem['delivery']['shippingAddress']['zipCode']),
                "endent" => $orderItem['delivery']['shippingAddress']['street'],
                "nument" => $orderItem['delivery']['shippingAddress']['number'],
                "complent" => $orderItem['delivery']['shippingAddress']['complement'],
                "baient" => $orderItem['delivery']['shippingAddress']['neighborhood'],
                "cident" => $orderItem['delivery']['shippingAddress']['city'],
                "estent" => $orderItem['delivery']['shippingAddress']['state']['name'],
            ],
            "itens" => $products,
            "totais" => [
                "totpedido" => $orderItem['total'],
                "totdesc" => $orderItem['totalDiscounts'],
                "vlrvenda" => $orderItem['total'] - $orderItem['totalDiscounts'],
            ],
            "priceList" => [
                "criteria" => "B2C",
                "price" => $orderItem['total'] - $orderItem['totalDiscounts'],
            ]
        ];
    }

    private function createClient(array $client, array $address)
    {
        $customer = CustomerModel::query()->where('cpf_cnpj', $client['cpfCnpj'])->first();

        if ($customer) {
            return;
        }

        $telephone = $this->validateTelephone($client['telephone']);

        $customer = [
            "numdoc" => preg_replace('/\D/', '', $client['cpfCnpj']),
            "nome" => $client['fullName'],
            "cep" => preg_replace('/\D/', '', $address['zipCode']),
            "endereco" => $address['street'],
            "numero" => $address['number'],
            "complemento" => $address['complement'],
            "bairro" => $address['neighborhood'],
            "cidade" => $address['city'],
            "estado" => $address['state']['zone'],
            "ddd" => $telephone['ddd'],
            "telefone" => preg_replace('/\D/', '', $telephone['numero']),
            "email" => $client['email'],
        ];

        $this->protheusHttpClient->clientCreate($customer);

        CustomerModel::query()->create([
            'cpf_cnpj' => $client['cpfCnpj'],
            'email' => $client['email'],
            'telephone' => $client['telephone'],
            'full_name' => $client['fullName'],
            'zip_code' => $address['zipCode'],
            'street' => $address['street'],
            'number' => $address['number'],
            'complement' => $address['complement'],
            'neighborhood' => $address['neighborhood'],
            'city' => $address['city'],
            'state' => $address['state']['zone'],
        ]);
    }

    private function validateTelephone($telephone) {
        // Remove todos os caracteres não numéricos
        $telephone = preg_replace('/\D/', '', $telephone);

        // Verifica se há um DDD (2 primeiros dígitos) ou assume "00"
        if (strlen($telephone) == 10 || strlen($telephone) == 11) {
            $ddd = substr($telephone, 0, 2);
            $numero = substr($telephone, 2);
        } elseif (strlen($telephone) == 8 || strlen($telephone) == 9) {
            $ddd = '00';
            $numero = $telephone;
        } else {
            return false; // Número inválido
        }

        // Retorna os valores formatados
        return [
            'ddd' => $ddd,
            'numero' => substr($numero, 0, 5) . '-' . substr($numero, 5)
        ];
    }
}
