<?php

namespace Domain\Protheus\API\Services;

use App\Application\Integrator\ApiClient;
use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Log;

class ProtheusHttpClient
{
    private const HOST_DEV = "http://protheushomo.alianca.ind.br:8802/rest/integsite";
    private const HOST_LIVE = "http://protheushomo.alianca.ind.br:8802/rest/integsite";

    #region Orders
    public function orderCreate(array $data)
    {
        $response = $this->dispatch("post", "/gravar", $data);

        if(!isset($response->json()['message']) || empty($response->json()['message'])){
            throw new \Exception("Código do pedido criado no protheus não retornado");
        }

        return $response->json();
    }

    public function orderStatus(string $id)
    {
        $data = [
            'numped' => $id
        ];

        $response = $this->dispatch("post", "/consulta", $data);

        return $response->json();
    }
    #endregion

    #region client
    public function clientCreate(array $data)
    {
        $response = $this->dispatch("post", "/cliente", $data);

        return $response->json();
    }
    #endregion

    #region Helpers
    /**
     * @param string $method
     * @param string $endpoint
     * @param array $data
     * @return Response
     * @throws \Exception
     */
    public function dispatch(string $method, string $endpoint, array $data = []): Response
    {
        $host = self::HOST_DEV;

        if(env("APP_ENV") == 'production'){
            $host = self::HOST_LIVE;
        }

        $url = $this->mountUrlApi($host, $endpoint);

        $response = (new ApiClient(
            ['Content-Type' => 'application/json'],
            $method,
            $url,
            $data
        ))->dispatch();

        Log::channel('protheus')->info('request para o protheus.', [
            'url' => $url,
            'response' => $response->json(),
            'response_body' => $response->body(),
            'data' => $data,
            'method' => $method,
            'success' => $response->successful(),
            'headers' => $response->headers()
        ]);

        if(!$response->successful() || !$response->json()['success']){

//            Log::channel('protheus')->info('Erro ao obter atualização de pedido.', [
//                'url' => $url,
//                'response' => $response->json(),
//                'endpoint' => $endpoint,
//                'data' => $data,
//                'method' => $method
//            ]);

            throw new \Exception($response->body());
        }

        return $response;
    }

    private function mountUrlApi(string $host, string $endpoint): string
    {
        if (!str_ends_with($host, '/')) {
            $host .= '/';
        }

        if (str_starts_with($endpoint, '/')) {
            $endpoint = substr($endpoint, 1);
        }

        return "{$host}{$endpoint}";
    }
    #endregion
}
