<?php

namespace App\Console\Commands\Orders;

use Carbon\Carbon;
use Domain\Hub4all\API\Service\Hub4allHttpClient;
use Domain\Order\Service\OrderService;
use Illuminate\Console\Command;

class ImportHub4allOrdersCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'orders:import';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Importa pedidos do hub4all';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $hub4allClient = new Hub4allHttpClient();

        $startDate = (new Carbon())->now()->subDays(7)->format('Y-m-d');
        $filter = [
            'status' => 2,
            'startDate' => $startDate,
            'endDate' => (new Carbon())->now()->format('Y-m-d'),
        ];

        $response = $hub4allClient->ordersGetAll($filter);

        if(count($response['data']['list']) > 0){
            $orderModel = new OrderService();
            foreach($response['data']['list'] as $orderItem){
                $orderModel->importFromHub4all($orderItem);
            }
        }
    }
}
