<?php

namespace App\Application\Integrator;

use App\Support\Uuid;
use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class ApiClient
{
    private string $uuid;
    private int $timeout = 0;
    private array $headers = [];
    private string $method;
    private array $methods = ['post', 'get', 'put', 'delete'];
    private string $url;
    private array $data;

    /**
     * Integrator constructor.
     * @param array $headers
     * @param string $method
     * @param string $url
     * @param array $data
     * @throws \Exception
     */
    public function __construct(array $headers, string $method, string $url, array $data = [])
    {
        $this->uuid = Uuid::generateUuid();
        $this->headers = $headers;
        $this->method = Str::slug($method);
        $this->url = $url;
        $this->data = $data;

        $this->validate();
    }

    public function timeout(int $timeout)
    {
        $this->timeout = $timeout;
    }

    public function dispatch(): Response
    {
        $request = Http::withHeaders($this->headers);

        if ($this->timeout > 0){
            $request->timeout($this->timeout);
        }

        $response = null;
        switch ($this->method){
            case 'get':
                $response = $request->get($this->url);
                break;
            case 'post':
                $response = $request->post($this->url, $this->data);
                break;
            case 'put':
                $response = $request->put($this->url,$this->data);
                break;
            case 'delete':
                $response = $request->delete($this->url, $this->data);
                break;
        }

        return $response;

    }

    private function validate()
    {
        if (!in_array($this->method, $this->methods)){
            throw new \Exception("Método de requisição inválido.");
        }
    }
}
