<?php

namespace Protheus;

use Domain\Protheus\API\Services\ProtheusHttpClient;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProtheusTest extends TestCase
{
    use RefreshDatabase;

    public function test_create_order()
    {
        $orderItem = '{
            "pedido": "000008",
            "total": 32.90,
            "promotionDiscount": 0,
            "dataCriacao": "2024-12-02 10:50:00",
            "dataUpdate": "2024-12-02 10:50:10",
            "deleteAt": "",
            "condicaopgto": "780",
            "mensagem": "Pagamento via PIX",
            "status": {
                "name": "status.paid",
                "info": null,
                "createdAt": "2024-01-13 18:28:38",
                "updatedBy": {
                    "email": null,
                    "isAPI": false,
                    "isSystem": true
                }
            },
            "cliente": {
                "numdoc": "93647778834",
                "nome": "ITAMAR DE CARVALHO JUNIOR",
                "cep": "03131020",
                "endereco": "R APOTI",
                "numero": "52",
                "complemento": "",
                "bairro": "VILA PRUDENTE",
                "cidade": "SAO PAULO",
                "estado": "SP"
            },
            "entrega": {
                "cepent": "03131020",
                "endent": "R APOTI",
                "nument": "52",
                "complent": "",
                "baient": "VILA PRUDENTE",
                "cident": "SAO PAULO",
                "estent": "SP"
            },
            "itens": [
                {
                    "produto": "061777",
                    "quantidade": 1,
                    "unitario": 32.90,
                    "total": 32.90,
                    "desconto": 0
                }
            ],
            "totais":{
                "totpedido": 32.90,
                "totdesc": 0,
                "vlrvenda": 32.90
            },
            "priceList": {
                "criteria": "B2C",
                "price": 32.90
            }
        }';

        $data = json_decode($orderItem, true);

        $protheusClient = new ProtheusHttpClient();
        $response = $protheusClient->orderCreate($data);

        dd($response);

        $this->assertTrue($response['success']);
        $this->assertNotNull($response['pedido']);//931712
    }

    public function test_get_order_status()
    {
        $protheusClient = new ProtheusHttpClient();
        $response = $protheusClient->orderStatus(931711);

        dd($response);
    }

}
