<?php

namespace App\Console\Commands\Orders;

use Carbon\Carbon;
use Domain\Order\Models\OrderModel;
use Domain\Order\Service\OrderService;
use Illuminate\Console\Command;

class CheckOrderUpdatesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'orders:check-updates';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verifica atualizações de pedidos no protheus';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle(): void
    {
        $startDate = (new Carbon())->now()->subDays(15);
        $endDate = (new Carbon())->now();

        $orders = OrderModel::query()
            ->where('created_at', '>=', $startDate)
            ->where('created_at', '<=', $endDate)
            ->whereNotNull('protheus_order_id')
            ->get();

        $orderService = new OrderService();
        foreach($orders as $order){
            if($order->protheus_order_id != 941630){
                continue;
            }
            $orderService->checkOrderUpdates($order->protheus_order_id);
        }
    }
}
